// ==UserScript==
// @name           Pennergame Highscore Script 2010
// @namespace      11235813[Bande:Dritteliga Penner]
// @description    Zeigt erweiterete Infos über Penner auf Highscore an
// @include        http://*game*/highscore/*
// @include		   *game*settings*
// @exclude		   *gang/*
// @exclude		   *.php*
// @exclude 	   *stuff*
// @require		   http://zahlii.independent-irc.com/script.class.js
// @require		   http://zahlii.independent-irc.com/updater.class.js
// @require		   http://zahlii.independent-irc.com/setting.class.js
// @require		   http://zahlii.independent-irc.com/sort.class.js
// ==/UserScript==



//Tier-Sammlung festlegen
var tiere = init();

//Globales Objekt für globale Variablen
vars = new Object();

vars.updateXML = 'http://zahlii.independent-irc.com/updateinfo.xml';
vars.version = '5.2.2';
vars.download = 'http://userscripts.org/scripts/source/67692.user.js';

vars.toplinks = {
			'News':Global.url.static+'news/',
			'Lets Fight':Global.url.static+'fight/overview/',
			'&Uuml;bersicht':Global.url.static+'overview/',
			'Bande':Global.url.static+'gang/',
			'Stadt':Global.url.static+'city/',
			'Kommunikation':Global.url.static+'messages/',
			'Bandenhighscore':Global.url.static+'highscore/gang/',
			'Mein Highscore':Global.url.static+'highscore/joindate/'
};
vars.toplinkslen = 8; //Anzahl der Links in vars.toplinks !

vars.thead = ['Rang',
			  'Spieler',
			  'Punkte',
			  'Diff',
			  'Stadt',
			  'RP',
			  'RegDatum',
			  'Geld',
			  'Tier',
			  'Plunder',
			  'Bande',
			  'Posten',
			  'Platz',
			  'BPkte',
			  'Beitritt',
			 ];

//Start, IDs und Spielerinfos sammeln
if(!isErrorPage()) {
	collectID();
}
//collectId()->changePage()->getDashboardData()->buildDashboard()->buildNavi()->getUserData()->getData(id)->getGangData(id)->getProfilData(id)->checkForFinish()->insertUserData();


/*
 *	Sammelt Benutzer-IDs der aktuellen Highscore-Seite
 */
function collectID() {
	try {
		var docIH = document.getElementById('my-profile').innerHTML;
	} catch(e) {
		var docIH = '';
	}
	vars.owndata = Object();
	var highscore_table = document.getElementsByTagName('table')[0];
	try {
		vars.ownid = Boolean(docIH.match(/profil\/id:(\d+)/)[1]) ? docIH.match(/profil\/id:(\d+)/)[1] : false;
		vars.owndata.name = vars.ownid ? document.getElementById('my-profile').getElementsByTagName('a')[0].innerHTML : false;
	} catch(e) {
		vars.ownid = false;
		vars.owndata.name = false;
	}
	vars.userids = [];
	if(vars.ownid!=false) {
		vars.owndata.cash = trim(document.getElementsByClassName('icon money')[0].textContent);
		vars.owndata.cash_1 = vars.owndata.cash.match(/\d+/g).join('');
		vars.owndata.permil = trim(document.getElementsByClassName('icon beer')[0].textContent);
		var overview = document.getElementById('my-profile');
		var data = overview.getElementsByClassName('el2');
		vars.owndata.platz = data[1].textContent;
		vars.owndata.punkte = data[2].textContent;
		vars.owndata.limits = [parseInt(vars.owndata.punkte*1.5),parseInt(vars.owndata.punkte*0.8)];	
	} else {
		vars.owndata.cash = '';
		vars.owndata.cash_1 = 0;
		vars.owndata.permil = '';
		vars.owndata.punkte = '';
		vars.owndata.platz = '';
		vars.owndata.won = vars.owndata.lost = '';
		vars.owndata.limits = [1E15,0]
		vars.owndata.att = vars.owndata.def = vars.owndata.fightval = '';
		vars.owndata.percwon = vars.owndata.perclost = 50;
	}
	if(!highscore_table.innerHTML.match(/profil/)) {
		return false;
	}
	vars.userdata = [];
	var table_rows = highscore_table.getElementsByTagName('tr');
	for(var a = 1; a < table_rows.length; a++) {
		var td = table_rows[a].getElementsByTagName('td');
		var current_id = table_rows[a].innerHTML.match(/profil\/id:(\d+)/)[1];
		vars.userids.push(current_id);
		vars.userdata[a-1] = [];
		vars.userdata[a-1].push(current_id);
		vars.userdata[a-1].push(trim(td[0].className));
		vars.userdata[a-1].push(td[3].innerHTML);
		vars.userdata[a-1].push(parseInt(td[4].textContent,10));
	}	
	changePage();
	GM_xmlhttpRequest
	({
    	method: 'get',
   		url: vars.updateXML,
		headers: {
        	'User-agent': 'Mozilla/5.0 (Windows; U; Windows NT 5.1; de; rv:1.9.0.6) Gecko/2009011913 Firefox/3.0.8',
        	'Accept': 'application/atom+xml,application/xml,text/xml',
		},
		onload: function(response) {
			var cont = response.responseText;
			var dom = setParser(cont,'XML');
			var dom = dom.getElementsByTagName('pghs_2010')[0];
			var vers = dom.getElementsByTagName('current')[0].textContent;
			var info = dom.getElementsByTagName('info')[0].textContent;
			var changes = dom.getElementsByTagName('changes')[0].textContent;
			if(vers!=vars.version) {
				vars.updateIt = '<span class="bann"><a href="'+vars.download+'">Update Installieren</a></span><br /><i>'+info+'</i><br /><small>'+changes+'</small>';
			} else {
				vars.updateIt = '<span class="on">Keine Updates!</span>';
			}
			getDashboardData();
		}
	});	
	return true;
}

/*
 *	Ändert HTML der Seite um
 */
function changePage() {
	window.focus();
	vars.lastnum = document.getElementById('pagination').getElementsByTagName('li');
	document.body.innerHTML = '';
	var head = document.getElementsByTagName('head')[0];
	head.innerHTML = '';
	head.appendChild(createElement('link',{rel:'stylesheet',href:'http://zahlii.independent-irc.com/style.css'}));
	head.appendChild(createElement('title',{},'Pennergame Highscore 2010'));
	var navi = createElement('div',{class:'topnav'});
	for(var link_name in vars.toplinks) {
		var href = createElement('a',{href:vars.toplinks[link_name]},link_name);
		var linkele = createElement('div',{style:'width:'+(100/vars.toplinkslen)+'%;'});
		linkele.appendChild(href);
		navi.appendChild(linkele);
	}
	document.body.appendChild(navi);
	document.body.appendChild(createElement('p',{style:'clear:both;'}));
	vars.dashboard = createElement('div',{id:'dashboard'});
	document.body.appendChild(vars.dashboard);
}

/*
 *	Baut HTML-Element mit gegebenen Attributen
 */
function createElement(type,attrs,inner) {
	var tmp_elem = document.createElement(type);
	if(!attrs) return tmp_elem;
	for(var att_name in attrs) {
		tmp_elem.setAttribute(att_name,attrs[att_name]);
	}
	if(inner==null || inner=='undefined') return tmp_elem;
	tmp_elem.innerHTML = inner;
	return tmp_elem;
}

/*
 * PHP-Style-Funktion trim (entfernt Leerzeichen an Anfang/Ende des Strings)
 */
function trim(zeichenkette) {
  return zeichenkette.replace (/^\s+/, '').replace (/\s+$/, '');
}

/*
 *	Ruft vom DashBoard angezeigte Daten ab und speichert diese in vars.owndata
 */
function getDashboardData() {
	if(vars.ownid==false) {
		buildDashboard();
	} else {
	GM_xmlhttpRequest
	({
    	method: 'get',
   		url: Global.url.static+'fight/',
		headers: {
        	'User-agent': 'Mozilla/5.0 (Windows; U; Windows NT 5.1; de; rv:1.9.0.6) Gecko/2009011913 Firefox/3.0.8',
        	'Accept': 'application/atom+xml,application/xml,text/xml',
		},
		onload: function(response) {
			var cont = response.responseText;
			var dom = setParser(cont,'HTML');
			var table = dom.getElementsByTagName('table')[0];
			vars.owndata.att = parseInt(getTable(table,2,3),10);
			vars.owndata.def = parseInt(getTable(table,2,4),10);
			vars.owndata.fightval = roundN(vars.owndata.att*1.16+vars.owndata.def,2);
			vars.owndata.won = parseInt(getTable(table,2,6),10);
			vars.owndata.lost = parseInt(getTable(table,2,7),10);
			vars.owndata.percwon = roundN(vars.owndata.won/(vars.owndata.won+vars.owndata.lost)*100,1)
			vars.owndata.perclost = roundN(vars.owndata.lost/(vars.owndata.won+vars.owndata.lost)*100,1);
			try {
			var inc_tbl = dom.getElementsByTagName('table')[2].getElementsByTagName('tr');
			if(inc_tbl.length==1) {
				vars.owndata.inclink = false;
				vars.owndata.incend = false;
			} else {
				var td = inc_tbl[2].getElementsByTagName('td');
				vars.owndata.inclink = td[2].innerHTML;
				vars.owndata.incend = td[1].textContent;
			}
			var out_tbl = table.getElementsByTagName('div')[0];
			var is_running = Boolean(out_tbl.innerHTML.match(/profil/));
			if(is_running) {
				vars.owndata.outlink = out_tbl.innerHTML.match(/<a.*?href="\/profil\/id:\d+\/".*?\/a>/);
				var name = out_tbl.getElementsByTagName('a')[0].innerHTML;
				var end = out_tbl.textContent.split(name)[1].match(/(\d+)/g);
				vars.owndata.outend = end[0]+'.'+end[1]+'.'+end[2]+' '+end[3]+':'+end[4]+':'+end[5];
			} else {
				vars.owndata.outlink = false;
				vars.owndata.outend = false;
			}
			}catch(e) {
				vars.owndata.incend = vars.owndata.inclink = vars.owndata.outend = vars.owndata.outlink = false;
				vars.owndata.att = vars.owndata.def = vars.owndata.fightval = vars.owndata.lost = vars.owndata.won = 0;
			}
			buildDashboard();
		}
	 
	});
	}
}

/*
 *	Greift auf das x. Feld der y. Spalte zu
 */
function getTable(table,x,y) {
	try {
		var moep = table.getElementsByTagName('tr')[y-1].getElementsByTagName('td')[x-1].textContent;
	} catch(e) {
		return '';
	} 
	return moep;
}

/*
 *	Füllt das DashBoard mit Daten 
 */
function buildDashboard() {
	var db = vars.dashboard;
	db.innerHTML = '<br /><span style="margin:10px;padding-top:10px;font-variant:small-caps;" class="head">'+(vars.owndata.name?vars.owndata.name:'Ausgeloggt!')+'</span><br /><img src="'+Global.url.ava+(vars.ownid?vars.ownid:'standard')+'.jpg" height="91px" style="float:left;margin:10px" />';
	
	db.appendChild(createElement('div',{class:'dbcolumn'},'<table><tr><td>Att:</td><td><b>'+vars.owndata.att+'</b></td></tr><tr><td>Def:</td><td><b>'+vars.owndata.def+'</b></td></tr><tr><td>FightVal:</td><td><b>'+vars.owndata.fightval+'</b></td></tr><tr><td>Plunder:</td><td><b>-</b></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td>Promille:</td><td><b>'+vars.owndata.permil+'</b></td></tr><tr><td>Geld:</td><td><b><span style="color:'+color(vars.owndata.cash_1)+'>'+vars.owndata.cash+'</span></b></td></tr></table>'));
	
	db.appendChild(createElement('div',{class:'dbcolumn'},'<table><tr><td>Platz:</td><td><b>'+vars.owndata.platz+'.</b></td></tr><tr><td>Punkte:</td><td><b>'+vars.owndata.punkte+'</b></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan="2"><span style="color:#c0c0c0;font-weight:bold;"><a href="'+Global.url.static+'highscore/user/?min='+vars.owndata.limits[1]+'&max='+vars.owndata.limits[0]+'">Angreifbare Spieler</a></span></td></tr><tr><td>&nbsp;</td><td><b>&nbsp;</b></td></tr><tr><td>Siege:</td><td><b>'+vars.owndata.won+'('+vars.owndata.percwon+'%)</b></td></tr><tr><td>Verloren:</td><td><b>'+vars.owndata.lost+'('+vars.owndata.perclost+'%)</b></td></tr></table>'));
	
	db.appendChild(createElement('div',{class:'dbcolumn'},'<table><tr><td colspan="2">'+(vars.owndata.outlink?'Angriff läuft auf:':'Kein laufender Angriff!')+'</td></tr><tr><td colspan="2"><b>'+(vars.owndata.outend?vars.owndata.outlink:'')+'</b></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan="2">'+(vars.owndata.outend?'<b><a href="/fight/cancel/">Abbrechen</a></b>':'')+'</td></tr><tr><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan="2">'+(vars.owndata.outend?'Ende gegen:':'')+'</td></tr><tr><td colspan="2">'+(vars.owndata.outend?vars.owndata.outend:'')+'</td></tr></table>'));
		
	db.appendChild(createElement('div',{class:'dbcolumn'},'<table><tr><td colspan="2">'+(vars.owndata.inclink?'Eingehender Angriff:':'Kein eingehender Angriff!')+'</td></tr><tr><td colspan="2"><b>'+(vars.owndata.incend?vars.owndata.inclink:'')+'</b></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan="2">'+(vars.owndata.incend?'Ende gegen:':'')+'</td></tr><tr><td colspan="2">'+(vars.owndata.incend?vars.owndata.incend:'')+'</td></tr><tr><td colspan="2">'+vars.updateIt+'</td></tr></table>'));	
	
	buildNavi();
}

/*
 *	Rundet eine Zahl auf stellen Nachkommastellen
 */
function roundN(number,stellen) {
	return parseInt(number*(Math.pow(10,stellen)))/(Math.pow(10,stellen));
}


/*
 *	Baut Naviagtion und Suchmaske zusammen
 */
function buildNavi() {
	var url = document.location.href;
	if(!url.match(/\/\d+\//)) {
		var teile = url.split('/');
		var letzterteil = teile.pop();
		var neueurl = teile.join('/');
		neueurl += '/1/';
		neueurl += letzterteil;
	} else {
		var neueurl = url;
	}
	var navi = createElement('div',{class:'topnav'});
	var page = parseInt(neueurl.match(/\/(\d+)\//)[1],10);
	if(page>5) var len = 13;
	else var len = page+7;
	var last_num = vars.lastnum;

	var last_num = last_num[last_num.length-1].textContent;
	var pagelink = neueurl.replace(/\/\d+\//,'/1/');
	var href = createElement('a',{href:pagelink},'&lt;&lt;Erste');
	var linkele = createElement('div',{style:'width:'+(100/len)+'%;'+style});
	linkele.appendChild(href);
	navi.appendChild(linkele);
	for(var i= page-5;i<=page+5;i++) {
		if(i>0) {
		var pagelink = neueurl.replace(/\/\d+\//,'/'+i+'/');
		var j = i;
		var style = '';
		if(i==page) {
			var style = 'background-color:#2c2c2c;';
			var j = i;
		} else if(i==page-1) {
			var style = 'background-color:#2d2d2d;';
			var j = '&lt;&lt;Vorherige';
		} else if(i==page+1) {
			var style = 'background-color:#2c2c2c;';
			var j = 'Nächste&gt;&gt;';
		}
		var href = createElement('a',{href:pagelink},j);
		var linkele = createElement('div',{style:'width:'+(100/len)+'%;'+style});
		linkele.appendChild(href);
		navi.appendChild(linkele);
		}
	}
	var pagelink = neueurl.replace(/\/\d+\//,'/'+last_num+'/');
	var href = createElement('a',{href:pagelink},'&gt;&gt;Letzte');
	var linkele = createElement('div',{style:'width:'+(100/len)+'%;'+style});
	linkele.appendChild(href);
	navi.appendChild(linkele);
	document.body.appendChild(navi);
	var navi = createElement('div',{class:'topnav'});
	var linkele = createElement('div',{style:'width:100%;'},'<form id="searchform" name="searchsome" method="get" action="">Penner:<input type="text" class="regex[4]" maxlength="32" size="19" id="search_penner" name="name" title="Penner" value="" />Bande:<input type="text" class="regex[4]" maxlength="64" size="17" id="search_bande" name="gang" title="Bande" value="" /><select id="search_stadtteil" name="district"><option value="0">---</option><option value="72">Allermöhe</option><option value="41">Alsterdorf</option><option value="73">Altengamme</option><option value="85">Altenwerder</option><option value="12">Altona Altstadt</option><option value="13">Altona Nord</option><option value="19">Altstadt</option><option value="8">Bahrenfeld</option><option value="42">Barmbek-Nord</option><option value="43">Barmbek-Süd</option><option value="74">Bergedorf</option><option value="54">Bergstedt</option><option value="20">Billbrook</option><option value="103">Billstedt</option><option value="75">Billwerder</option><option value="3">Blankenese</option><option value="21">Borgfelde</option><option value="55">Bramfeld</option><option value="86">Cranz</option><option value="76">Curslack</option><option value="44">Dulsberg</option><option value="56">Duvenstedt</option><option value="30">Eidelstedt</option><option value="57">Eilbek</option><option value="33">Eimsbüttel</option><option value="87">Eißendorf</option><option value="45">Eppendorf</option><option value="58">Farmsen-Berne</option><option value="14">Finkenwerder</option><option value="88">Francop</option><option value="46">Fuhlsbüttel</option><option value="47">Groß Borstel</option><option value="9">Groß Flottbek</option><option value="89">Gut Moor</option><option value="28">HafenCity</option><option value="23">Hamm-Mitte</option><option value="24">Hamm-Nord</option><option value="25">Hamm-Süd</option><option value="22">Hammerbrook</option><option value="90">Harburg</option><option value="34">Harvestehude</option><option value="91">Hausbruch</option><option value="92">Heimfeld</option><option value="48">Hoheluft-Ost</option><option value="35">Hoheluft-West</option><option value="49">Hohenfelde</option><option value="26">Horn</option><option value="59">Hummelsbuettel</option><option value="4">Iserbrook</option><option value="60">Jenfeld</option><option value="77">Kirchwerder</option><option value="27">Kleiner Grasbrook</option><option value="93">Langenbek</option><option value="50">Langenhorn</option><option value="61">Lemsahl-Mellingstedt</option><option value="78">Lohbrügge</option><option value="36">Lokstedt</option><option value="7">Lurup</option><option value="62">Marienthal</option><option value="94">Marmstorf</option><option value="95">Moorburg</option><option value="79">Moorfleet</option><option value="96">Neuenfelde</option><option value="80">Neuengamme</option><option value="98">Neugraben-Fischbek</option><option value="97">Neuland</option><option value="18">Neustadt</option><option value="37">Niendorf</option><option value="5">Nienstedten</option><option value="81">Ochsenwerder</option><option value="51">Ohlsdorf</option><option value="6">Osdorf</option><option value="10">Othmarschen</option><option value="11">Ottensen</option><option value="63">Poppenbuettel</option><option value="64">Rahlstedt</option><option value="82">Reitbrook</option><option value="1">Rissen</option><option value="99">Rönneburg</option><option value="29">Rothenburgsort</option><option value="38">Rotherbaum</option><option value="65">Sasel</option><option value="39">Schnelsen</option><option value="100">Sinstorf</option><option value="83">Spadenland</option><option value="31">St. Georg</option><option value="17">St.Pauli</option><option value="66">Steilshoop</option><option value="16">Steinwerder</option><option value="40">Stellingen</option><option value="2">Sülldorf</option><option value="84">Tatenberg</option><option value="67">Tonndorf</option><option value="52">Uhlenhorst</option><option value="32">Veddel</option><option value="68">Volksdorf</option><option value="15">Waltershof</option><option value="69">Wandsbek</option><option value="70">Wellingsbüttel</option><option value="101">Wilhelmsburg</option><option value="102">Wilstorf</option><option value="53">Winterhude</option><option value="71">Wohldorf-Ohlstedt</option></select>Bereich:<input type="text" class="regex[number]" maxlength="9" size="3" id="search_min" name="min" title="Min" value="0"> - <input type="text" class="regex[number]" maxlength="9" size="3" id="search_max" name="max" title="Max" value=""><input type="image" name="submit" value="Absenden" src="http://static.pennergame.de/img/pv4/icons/icon_search-go.png"></form>');
	vars.inputs = linkele.getElementsByTagName('input');
	navi.appendChild(linkele);
	document.body.appendChild(navi);
	getUserData();
}

/*
 *	Startet Spielerinfo-Abruf-Funktion
 */
function getUserData() {
 	vars.callNumber = 0;
	 for(var c=0;c<vars.userids.length;c++) {
		 getData(vars.userids[c],c);	 
	 }
}
 
 /*
  *	Überprüft, ob alle Infos gesammelt
  */
function checkForFinish() {
   vars.callNumber++;
   if(vars.callNumber==vars.userids.length || vars.callNumber>22) {
	   insertUserData();
   }
}

/* 
 *	Sammelt eigentliche Daten
 *
 *		vars.userdata[id] = [
						   Spieler-ID,						0
						   Trend-ClassName,					1
						   Stadtteil(HTML),					2
						   Punkte(Highscore),					3
						   Spielername,						4
						   Platz,								5
						   Punkte(API),						6
						   Differenz-Punkte,					7
						   Rangpunkte,						8
						   Geld(unformatiert) oder false,		9
						   RegDatum							10
						   
						   Bandenid oder false,				11 
						   Bandenname oder <leer>,			12
						   
						   Bandenstatus oder 0,				13
						   Bandenbeitritt oder <leer>,		14
						   
						  
						   Bandenplatz oder <leer>,			16
						   Bandenpunkte oder <leer>,			15
						   
						   Tieradresse oder false,			17
						   Plunderadresse oder false,			18
						   Status (1 Bann,2 Online)			19
						  ];
 */
function getData(id,c) {
   GM_xmlhttpRequest
   ({
	  method: 'get',
	  url: Global.url.static+'dev/api/user.'+id+'.xml',
	  headers: {
		  'User-agent': 'Mozilla/5.0 (Windows; U; Windows NT 5.1; de; rv:1.9.0.6) Gecko/2009011913 Firefox/3.0.8',
		  'Accept': 'application/atom+xml,application/xml,text/xml',
	  },
	  onload: function(response) {
		  var cont = response.responseText;
		  var dom = setParser(cont,'XML'); 
		  var name = dom.getElementsByTagName('name')[0].textContent;
		  var platz = dom.getElementsByTagName('position')[0].textContent;
		  var punkte = parseInt(dom.getElementsByTagName('points')[0].textContent,10);
		  var differenz = punkte-vars.userdata[c][3];
		  var rankpunkte = dom.getElementsByTagName('rankingpoints')[0].textContent;
		  try {
			  var cash = dom.getElementsByTagName('cash')[0].textContent;
		  } catch(e) {
			  var cash = false;
		  }
		  var reg = dom.getElementsByTagName('reg_since')[0].textContent;
		  var gang_id = dom.getElementsByTagName('id')[1].textContent;
		  var gang_id = gang_id!='None' ? gang_id : false;
		  vars.userdata[c].push(name);
		  vars.userdata[c].push(parseInt(platz,10));
		  vars.userdata[c].push(parseInt(punkte,10));
		  vars.userdata[c].push(differenz);
		  vars.userdata[c].push(parseInt(rankpunkte,10));
		  vars.userdata[c].push(cash?parseInt(cash,10):false);
		  vars.userdata[c].push(reg);
		  vars.userdata[c].push(gang_id);
		  if(gang_id) {
			  vars.userdata[c].push(dom.getElementsByTagName('name')[1].textContent);
			  vars.userdata[c].push(parseInt(dom.getElementsByTagName('status')[0].textContent,10));
			  vars.userdata[c].push(dom.getElementsByTagName('joined')[0].textContent);
			  getGangData(id,c);
		  } else {
			  vars.userdata[c].push('');
			  vars.userdata[c].push(0);
			  vars.userdata[c].push('');
			  
			  vars.userdata[c].push('');
			  vars.userdata[c].push('');			
			  getProfilData(id,c);
		  }
	  }
   });	
}

function getGangData(id,c) {
   var gang_id = vars.userdata[c][11];
   GM_xmlhttpRequest
   ({
	  method: 'get',
	  url: Global.url.static+'dev/api/gang.'+gang_id+'.xml',
	  headers: {
		  'User-agent': 'Mozilla/5.0 (Windows; U; Windows NT 5.1; de; rv:1.9.0.6) Gecko/2009011913 Firefox/3.0.8',
		  'Accept': 'application/atom+xml,application/xml,text/xml',
	  },
	  onload: function(response) {
		  var cont = response.responseText;
		  var dom = setParser(cont,'XML'); 
		  vars.userdata[c].push(parseInt(dom.getElementsByTagName('points')[0].textContent,10));
		  vars.userdata[c].push(parseInt(dom.getElementsByTagName('position')[0].textContent,10));
		  getProfilData(id,c);
	  }
   });
}
function getProfilData(id,c) {
   GM_xmlhttpRequest
   ({
	  method: 'get',
	  url: Global.url.static+'profil/id:'+id+'/',
	  headers: {
		  'User-agent': 'Mozilla/5.0 (Windows; U; Windows NT 5.1; de; rv:1.9.0.6) Gecko/2009011913 Firefox/3.0.8',
		  'Accept': 'application/atom+xml,application/xml,text/xml',
	  },
	  onload: function(response) {
		  var cont = response.responseText;
		  if(cont.match(/bann/)) {
			  var stat = 1;
		  }
		  if(cont.match(/(Ist gerade Online|Est actuellement en ligne)/)) {
			  var stat = 2
		  } else {
			  var stat = 0;
		  }
		  var dom = setParser(cont,'HTML'); 
		  
		  //Tier-Bild
		  var is_premium = Boolean(cont.match(/premiummedia/));
		  if(is_premium) {
			  try {
				  var pet_div = dom.getElementsByClassName('user_pet_position')[0];
				  var pet_img = pet_div.getElementsByTagName('img')[0].src;
			  } catch(e) {
				  var pet_img = false;
			  }
		  } else {
			  var pet_div = dom.getElementsByTagName('table')[2];
			  if(!pet_div.innerHTML.match(/headline/)) {
				  var pet_img = false;
			  } else {
				  var pet_img = pet_div.getElementsByTagName('img')[1].src;
				  if(pet_img.match(/\?\d+/)) {
					  try {
						  var tooltip = pet_div.getElementsByClassName('tooltip_pl')[0];
						  var name_tier = tooltip.getElementsByTagName('b')[1].textContent;
						  var pet_img = Global.url.media+tiere[name_tier];
					  } catch(e) {
					  }
				  }
			  }
		  }
		  // Plunder-Bild
		  try {
			  var plunder_img = dom.getElementsByClassName('item_pic')[0].src;
		  } catch(e) {
			  var plunder_img = false;
			  try {
				  var icon_top = dom.getElementsByClassName('sex')[0].src;
				  if(!icon_top.match(/male/)) {
					  var plunder_img = icon_top;
				  }
			  } catch(e) {
				  var plunder_img = false;
			  }
		  }
		  vars.userdata[c].push(pet_img);
		  vars.userdata[c].push(plunder_img);
		  vars.userdata[c].push(stat);
		  checkForFinish();
	  }
   });
}

function insertUserData() {
   var table = createElement('table',{id:'table',width:'100%'});
   var thead = createElement('thead');
   var tr = createElement('tr');
   for(e=0;e<vars.thead.length;e++) {
	   tr.appendChild(createElement('th',{},vars.thead[e]));
   }
   thead.appendChild(tr);
   table.appendChild(thead);
   if(document.getElementById('table')) {
	   var tbl_old = document.getElementById('table');
	   tbl_old.parentNode.removeChild(tbl_old);
   }
   var tbody = createElement('tbody');
   for(var f=0;f<vars.userids.length;f++) {
	  var tr = createElement('tr');
	  var data = vars.userdata[f];
	  //472855,col1 up,St.Pauli,754574,EmscherHeinz,6210,754574,0,0,489962,06.09.2008,90218,Deutsch_Oesterreichischer_Pakt,2,01.01.1970,2527624,503,false,false
	  for(g=0;g<vars.thead.length;g++) {
		  var name = vars.thead[g];
		  var obj = {};
		  switch(name) {
			  case 'Rang':
				  var obj = {class:data[1]};
				  var cont = '<b>'+data[5]+'.</b>';
				  break;
			  case 'Spieler':
				  var cont = '<a href="'+Global.url.static+'profil/id:'+data[0]+'/">'+data[4]+'</a>';
				  if(data[6]<vars.owndata.limits[0] && data[6]>vars.owndata.limits[1]) {
					  cont += '<br /><a href="'+Global.url.static+'fight/?to='+data[4]+'"><img src="http://media.pennergame.de/img/att.png" style="border:none;height:18px;"/></a>';
				  }
				  cont += '<br />'+['','<span class="bann">Bann</span>','<span class="on">Online</span>'][data[19]];
				  break;
			  case 'Punkte':
				  var cont = data[6];
				  break;
			  case 'Diff':
				  var cont = data[7];
				  break;
			  case 'Stadt':
				  var cont = data[2];
				  break;
			  case 'RP':
				  var cont = data[8];
				  break;
			  case 'RegDatum':
				  var cont = data[10];
				  break;
			  case 'Geld':
				  var cash = data[9];
				  if(!cash) {
					  var cont = '';
				  } else {
					  var col = color(cash);
					  var cont = '<span style="font-weight:bold;color:'+col+'">'+format(cash)+'</span>';
				  }
				  break;
			  case 'Tier':
				  var pet = data[17];
				  if(!pet) {
					  var cont = '';
				  } else {
					  var cont = '<img src="'+pet+'" width="60px" height="68px" />';
				  }
				  break;
			  case 'Plunder':
				  var plunder = data[18];
				  if(!plunder) {
					  var cont = '&nbsp;';
				  } else {
					  var cont = '<img src="'+plunder+'" />';
				  }
				  break;
			  case 'Bande':
				  var cont = data[11] ? '<a href="'+Global.url.static+'profil/bande:'+data[11]+'/">'+data[12]+'</a>' : '';
				  break;
			  case 'Posten':
				  var cont = ['','Mitglied','CoAdmin','Admin'][data[13]];
				  break;
			  case 'Platz':
				  var cont = data[16];
				  break;
			  case 'BPkte':
				  var cont = data[15];
				  break;
			  case 'Beitritt':
				  var cont = data[14]; 
				  break;
			  default:
				  var cont = data[g];
				  break;
		  }
		  tr.appendChild(createElement('td',obj,cont));
	  } 	
	  tr.className = (f%2==0)?'even':'odd';
	  tbody.appendChild(tr);
   }
   table.appendChild(tbody);
   document.body.appendChild(table);
   sortStart();
}
function isErrorPage() {
	if(!document.getElementsByTagName('table')) return true;
	else return false;
}